// Importing login and request functions from './server.js'
import { login, request } from './server.js'

// Asynchronous function to execute code
(async () => {
  // Performing user login and obtaining authentication token
  const token = await login()
  
  // Constructing the request to search for the item
  const reqItem = `query { search(
    requests: [
        {
            entity: ITEM, 
            offset: 0, 
            limit: 10,
            where: {typeIdentifier: "item",values: {size: {OP_gt: "118"}}}, 
            order: []
        }]
    ) {
    responses {
        ... on ItemsSearchResponse {
            count
            rows {
              identifier
              name
              values
            }
        }
    }}}`
  
  // Sending the request to search for the item
  let response = await request(token, reqItem)
  // Extracting found items from the response
  const foundItems = response.data.search.responses[0].rows
  console.log(foundItems)

  // Iterating through found items
  for (const item of foundItems) {
    // Modifying the voltage value format
    const newVoltage = item.values.voltage.replace("-", "~")

    // Constructing the request to update the item
    const UpdateReq = `mutation { import(
      config: {
          mode: UPDATE_ONLY
          errors: PROCESS_WARN
      },
      items: [
          {
              identifier: "${item.identifier}",
              values: {voltage: "${newVoltage}"}
          }
      ]
      ) {
      items {
        result
        id
        errors { code message }
        warnings { code message }
    }}}`
    
    // Sending the request to update the item
    const UpdateResponse = await request(token, UpdateReq)
    console.log('      updated item: ' + JSON.stringify(UpdateResponse))
  }

})()