
// Importing library for making HTTP requests
import fetch from 'node-fetch'

// Server address and user credentials
const server = 'http://localhost:80'
const user = 'admin'
const password = 'admin'

// Function for user authentication
export async function login() {
    // Constructing a request for user login
    const request = 'mutation {signIn(login: "' + user + '", password: "' + password + '") { token }}'
    const query = { query: request }
    // Sending the request to the server
    const res = await fetch(server + '/graphql', {
        method: 'post',
        body: JSON.stringify(query),
        headers: { 'Content-Type': 'application/json' },
    })
    // Handling the response from the server
    const json = await res.json()
    // Проверка на наличие ошибок в ответе
    if (json.errors) throw new Error(json.errors[0].message)
    // Returning the authentication token
    return json.data.signIn.token
}

// Function for making requests to the server
export async function request(token, req) {
    const query = { query: req }
     // Sending the request to the server with the authentication token
    const res = await fetch(server + '/graphql', {
        method: 'post',
        body: JSON.stringify(query),
        headers: { 'Content-Type': 'application/json', 'x-token': token },
    })
    // Handling the response from the server
    const json = await res.json()
    // Logging error information to the console
    if (json.errors) {
        // Logging error information to the console
        console.error("Request error:" + JSON.stringify(json) + ", for query: " + req)
        // Throwing an exception in case of error
        throw new Error('Request error')
    }
    // Returning the result of the request
    return json
}
