import requests

# Server address and user credentials
server = 'http://localhost:80'
user = 'admin'
password = 'admin'

def login():
    # Constructing a request for user login
    request = 'mutation {signIn(login: "' + user + '", password: "' + password + '") { token }}'
    query = { 'query': request }
    # Sending the login request to the server
    res = requests.post(server + '/graphql', json=query, headers={'Content-Type': 'application/json'})
    json_data = res.json()
    # Handling errors in the response
    if 'errors' in json_data:
        raise Exception(json_data['errors'][0]['message'])
    # Returning the authentication token
    return json_data['data']['signIn']['token']

def request(token, req):
    query = { 'query': req }
    headers = { 'Content-Type': 'application/json', 'x-token': token }
    # Sending the request to the server with the token
    res = requests.post(server + '/graphql', json=query, headers=headers)
    json_data = res.json()
    # Handling errors in the response
    if 'errors' in json_data:
        print("Request error:", json_data, ", for query:", req)
        raise Exception('Request error')
    return json_data

if __name__ == "__main__":
    # Performing user login and obtaining the authentication token
    token = login()

    # Constructing the request to search for items
    req_item = '''query { search(
        requests: [
            {
                entity: ITEM,
                offset: 0,
                limit: 1000,
                where: {values: {color: 4}},
                order: []
            }]
        ) {
        responses {
            ... on ItemsSearchResponse {
                count
                rows {
                  identifier
                  name
                  values
                }
            }
        }}}'''

    # Sending the request to search for items
    response = request(token, req_item)
    found_items = response['data']['search']['responses'][0]['rows']
    print(found_items)

    # Iterating through found items
    for item in found_items:
        # Constructing the request to update each item
        update_req = '''mutation { import(
            config: {
                mode: UPDATE_ONLY
                errors: PROCESS_WARN
            },
            items: [
                {
                    identifier: "''' + item['identifier'] + '''",
                    values: {color: 1}
                }
            ]
            ) {
            items {
              result
              id
              errors { code message }
              warnings { code message }
        }}}'''

        # Sending the update request for each item
        update_response = request(token, update_req)
        print('      updated item:', update_response)
